options nodate nocenter ls=90 ps=30 pageno=1;

proc corr data=ratio2;
var ratiod site cclass bark dbh logs tier ba cratio lfi tsi slope injury;
run;

options nodate nocenter ls=90 ps=30 pageno=1;
*---PREDICTION MODEL USING SITE AS A RANDOM BLOCKING FACTOR---*;
proc mixed data=ratio2;
	class site tier ;
	model ratiod = tier lfi / solution;
	random site;
	title "ALL TREES";
	output out=residuals r=residuals;
run;

*---SITE COMPARISONS--;
proc glm data=ratio2;
class site;
model ratiod = site;
lsmeans site / adj=tukey;
output out=siteresid r=residuals;
run;

proc univariate data=siteresid normal;
run;

*---REGIONAL COMPARISONS---;
proc glm data=ratio2;
class region site ;
model ratiod = region site(region);
random site(region)/test;
lsmeans region / e=site(region) adj=tukey;
output out=regionresid r=residuals;
run;

proc univariate data=regionresid normal;
run;

*---BARK TYPE COMPARISONS---;
proc glm data=ratio2;
class site bark;
model ratiod = site bark ;
lsmeans bark / pdiff adj=tukey ;
output out=barkresid r=residuals;
run;

proc univariate data=barkresid normal;
run;

*---INJURY COMPARISONS---;
proc glm data=ratio2;
class site injury;
model ratiod = site injury ;
lsmeans injury / pdiff adj=tukey;
output out=injuryresid r=residuals;
run;

proc univariate data=injuryresid normal;
run;


